#include <jni.h>      /* Java Native Interface headers */
#include "StandardBarrierOptPrice.h"   /* Auto-generated header created by javah -jni */

/* Our C definition of the function S30FAF declared in EuropeanOptPrice.java */
JNIEXPORT jint JNICALL Java_StandardBarrierOptPrice_s30faf
  (JNIEnv *env, jobject obj, jchar calput, jstring type, jint m, jint n,
   jdoubleArray x, jdouble s, jdouble h, jdouble k, jdoubleArray t, 
   jdouble sigma, jdouble r, jdouble q, jdoubleArray p, jint ldp)
{ 
  /* Local variable ifail*/
  int ifail;

  /* First extract the arrays and string from Java */
  jdouble *xpt, *tpt, *ppt;
  jboolean isCopy;
  const char *typept;

  xpt = (*env)->GetDoubleArrayElements(env, x, &isCopy);
  tpt = (*env)->GetDoubleArrayElements(env, t, &isCopy);
  ppt = (*env)->GetDoubleArrayElements(env, p, &isCopy);
  typept = (*env)->GetStringUTFChars(env, type, 0);

  /* Call S30FAF */
  ifail = -1;
#ifdef WINDOWS
  S30FAF(&calput, 1, typept, 2, 
#else
  s30faf_(&calput, typept,
#endif 
       &m, &n, xpt, &s, &h, &k, tpt, &sigma, &r, &q, ppt,
       &ldp, &ifail);

  /* Release the array elements back to Java */
  (*env)->ReleaseDoubleArrayElements(env, x, xpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, t, tpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, p, ppt, 0);
  /* Free up the Java string argument so we don't leak memory. */
  (*env)->ReleaseStringUTFChars(env, type, typept);

  return ifail;
}
