public class StandardBarrierOptPrice
{

  // Declaration of the Native (C) function
  private native int s30faf(char calput, String type, int m, int n, double[] x, 
                            double s, double h, double k, double[] t, 
                            double sigma, double r, double q, double[] p, 
                            int ldp);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[];
      double s, h, k, sigma, r, q;
      int i, j, m, n, ldp, retCode;
      char calput;
      String type;

      // Create an object of class StandardBarrierOptPrice
      StandardBarrierOptPrice price = new StandardBarrierOptPrice();

      calput = 'P';
      type = "DI";
      s = 100.0;
      h = 95.0;
      k = 3.0;
      sigma = 0.3;
      r = 0.08;
      q = 0.04;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n]; 
      x = new double[m];
      t = new double[n];

      x[0] = 100.0;
      t[0] = 0.5;

      System.out.println();
      System.out.println("Call of NAG Standard barrier option pricing routine S30FAF");
      System.out.println();

      // Call method s30faf of object price
      retCode = price.s30faf(calput, type, m, n, x, s, h, k, t, sigma, r, q, 
                             p, ldp);

      System.out.print("Return code from S30FAF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("Put:");
          System.out.println("Down-and-In:");
          System.out.println("Spot " + s);
          System.out.println("Barrier " + h);
          System.out.println("Rebate " + k);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Dividend " + q);
          System.out.println();

          // Print the solution
          System.out.println(" Strike      Expiry   Option Price");
          for (i = 0; i < m; i++)
            for (j = 0; j < n; j++)
            {
              System.out.format("%8.4f   %8.4f   %8.4f%n",x[i],t[j],p[j*m + i]);
            }
        }
      System.out.println();
    }
}
