public class MertonJumpDifOptPriceGreeks
{

  // Declaration of the Native (C) function
  private native int s30jbf(char calput, int m, int n, double[] x, double s,
                            double[] t, double sigma, double r, double lambda, 
                            double jvol, double[] p, int ldp, double[] delta,  
                            double[] gamma, double[] vega, double[] theta,
                            double[] rho, double[] vanna, double[] charm, 
                            double[] speed,  double[] colour, double[] zomma,
                            double[] vomma);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[], delta[], gamma[], vega[], theta[], rho[], vanna[],
             charm[], speed[], colour[], zomma[], vomma[];
      double s, sigma, r, lambda, jvol;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class MertonJumpDifOptPriceGreeks
      MertonJumpDifOptPriceGreeks price = new MertonJumpDifOptPriceGreeks();

      calput = 'C';
      lambda = 5.0;
      s = 100.0;
      sigma = 0.25;
      r = 0.08;
      jvol = 0.25;
      m = 2;
      n = 1;
      ldp = m;

      p = new double[ldp*n];
      delta = new double[ldp*n];
      gamma = new double[ldp*n];
      vega = new double[ldp*n];
      theta = new double[ldp*n];
      rho = new double[ldp*n];
      vanna = new double[ldp*n];
      charm = new double[ldp*n];
      speed = new double[ldp*n];
      colour = new double[ldp*n];
      zomma = new double[ldp*n];
      vomma = new double[ldp*n];
      x = new double[m];
      t = new double[n];

      x[0] = 80.0;
      x[1] = 90.0;
      t[0] = 0.5;

      System.out.println();
      System.out.println("Call of NAG Merton jump-diffusion model option pricing with Greeks routine S30JBF");
      System.out.println();

      // Call method s30jbf of object price
      retCode = price.s30jbf(calput, m, n, x, s, t, sigma, r, lambda, jvol, p,
                             ldp, delta, gamma, vega, theta, rho, vanna, 
                             charm, speed, colour, zomma, vomma);

      System.out.print("Return code from S30JBF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("European Call:");
          System.out.println("Spot " + s);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Jumps " + lambda);
          System.out.println("Jump vol " + jvol);
          System.out.println();

          // Print the solution
          for (j = 0; j < n; j++)
            {
              System.out.println("Time to Expiry : " + t[j]);
              System.out.print(" Strike     Price     Delta     Gamma    ");
              System.out.println("Vega      Theta      Rho");
              for (i = 0; i < m; i++)
                {
                  System.out.format("%7.4f   %7.4f   %7.4f   ",x[i],p[j*m + i],delta[j*m + i]);
                  System.out.format("%7.4f   %7.4f",gamma[j*m + i],vega[j*m + i]);
                  System.out.format("   %7.4f   %7.4f%n",theta[j*m + i],rho[j*m + i]);
                }
              System.out.println();
              System.out.print(" Strike     Price     Vanna    Charm     Speed");
              System.out.println("     Colour    Zomma      Vomma");
              for (i = 0; i < m; i++)
                {
                  System.out.format("%7.4f   %7.4f   %7.4f   ",x[i],p[j*m + i],vanna[j*m + i]);
                  System.out.format("%7.4f   %7.4f",charm[j*m + i],speed[j*m + i]);
                  System.out.format("   %7.4f   %7.4f   %7.4f%n",colour[j*m + i],zomma[j*m + i],vomma[j*m + i]);
                }
              System.out.println();
            }
        }
    }
}
