public class MertonJumpDifOptPrice
{

  // Declaration of the Native (C) function
  private native int s30jaf(char calput, int m, int n, double[] x, double s,
                            double[] t, double sigma, double r, double lambda,
                            double jvol, double[] p, int ldp);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[];
      double s, sigma, r, lambda, jvol;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class MertonJumpDifOptPrice
      MertonJumpDifOptPrice price = new MertonJumpDifOptPrice();

      calput = 'C';
      lambda = 3.0;
      s = 45.0;
      sigma = 0.25;
      r = 0.1;
      jvol = 0.4;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n];
      x = new double[m];
      t = new double[n];

      x[0] = 55.0;
      t[0] = 0.25;

      System.out.println();
      System.out.println("Call of NAG Merton jump-diffusion model option pricing routine S30JAF");
      System.out.println();

      // Call method s30jaf of object price
      retCode = price.s30jaf(calput, m, n, x, s, t, sigma, r, lambda, jvol, p,
                             ldp);

      System.out.print("Return code from S30JAF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("European Call:");
          System.out.println("Spot " + s);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Jumps " + lambda);
          System.out.println("Jump vol " + jvol);
          System.out.println();

          // Print the solution
          System.out.println(" Strike      Expiry     Option Price");
          for (i = 0; i < m; i++)
            {
              for (j = 0; j < n; j++)
                System.out.format("%8.4f   %8.4f   %8.4f%n",x[i],t[j],p[j*m + i]);
            }
          System.out.println();
        }
    }
}
