public class HestonOptPrice
{

  // Declaration of the Native (C) function
  private native int s30naf(char calput, int m, int n, double[] x, double s,
                            double[] t, double sigmav, double kappa, 
                            double corr, double varo, double eta, double gamma,
                            double r, double q, double[] p, int ldp);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[];
      double s, sigmav, kappa, corr, varo, eta, gamma, r, q;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class HestonOptPrice
      HestonOptPrice price = new HestonOptPrice();

      calput = 'C';
      s = 100.0;
      r = 0.05;
      q = 0.0;
      kappa = 2.0;
      eta = 0.01;
      varo = 0.01;
      sigmav = 0.225;
      corr = 0.0;
      gamma = 1.0;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n];
      x = new double[m];
      t = new double[n];

      x[0] = 100.0;
      t[0] = 0.5;

      System.out.println();
      System.out.println("Call of NAG Heston's stochastic volatility model option pricing routine S30NAF");
      System.out.println();

      // Call method s30naf of object price
      retCode = price.s30naf(calput, m, n, x, s, t, sigmav, kappa, corr, varo,
                             eta, gamma, r, q, p, ldp);

      System.out.print("Return code from S30NAF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("European Call:");
          System.out.println("Spot " + s);
          System.out.println("Volatility  of vol " + sigmav);
          System.out.println("Mean reversion " + kappa);
          System.out.println("Correlation " + corr);
          System.out.println("Variance " + varo);
          System.out.println("Mean of variance " + eta);
          System.out.println("Risk aversion " + gamma);
          System.out.println("Rate " + r);
          System.out.println("Dividend " + q);
          System.out.println();

          // Print the solution
          System.out.println(" Strike      Expiry     Option Price");
          for (i = 0; i < m; i++)
            {
              for (j = 0; j < n; j++)
                System.out.format("%8.4f   %8.4f   %8.4f%n",x[i],t[j],p[j*m + i]);
            }
          System.out.println();
        }
    }
}
