#include <jni.h>      /* Java Native Interface headers */
#include "FSLOptPrice.h"   /* Auto-generated header created by javah -jni */

/* Our C definition of the function S30BAF declared in EuropeanOptPrice.java */
JNIEXPORT jint JNICALL Java_FSLOptPrice_s30baf
  (JNIEnv *env, jobject obj, jchar calput, jint m, jint n, jdoubleArray sm, 
   jdouble s, jdoubleArray t, jdouble sigma, jdouble r, jdouble q, 
   jdoubleArray p, jint ldp)
{ 
  /* Local variable ifail*/
  int ifail;

  /* First extract the arrays from Java */
  jdouble *smpt, *tpt, *ppt;
  jboolean isCopy;

  smpt = (*env)->GetDoubleArrayElements(env, sm, &isCopy);
  tpt = (*env)->GetDoubleArrayElements(env, t, &isCopy);
  ppt = (*env)->GetDoubleArrayElements(env, p, &isCopy);
  
  /* Call S30BAF */
  ifail = -1;
#ifdef WINDOWS
  S30BAF(&calput, 1, 
#else
  s30baf_(&calput,
#endif 
      &m, &n, smpt, &s, tpt, &sigma, &r, &q, ppt, &ldp, &ifail);

  /* Release the array elements back to Java */
  (*env)->ReleaseDoubleArrayElements(env, sm, smpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, t, tpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, p, ppt, 0);

  return ifail;
}
