#include <jni.h>      /* Java Native Interface headers */
#include "FSLOptPriceGreeks.h"   /* Auto-generated header created by javah -jni */

/* Our C definition of the function S30BBF declared in FSLOptPriceGreeks.java */
JNIEXPORT jint JNICALL Java_FSLOptPriceGreeks_s30bbf
  (JNIEnv *env, jobject obj, jchar calput, jint m, jint n, jdoubleArray sm, 
   jdouble s, jdoubleArray t, jdouble sigma, jdouble r, jdouble q, 
   jdoubleArray p, jint ldp, jdoubleArray delta, jdoubleArray gamma, 
   jdoubleArray vega, jdoubleArray theta, jdoubleArray rho, jdoubleArray crho, 
   jdoubleArray vanna, jdoubleArray charm, jdoubleArray speed, 
   jdoubleArray colour, jdoubleArray zomma, jdoubleArray vomma)
{ 
  /* Local variable ifail*/
  int ifail;

  /* First extract the arrays from Java */
  jdouble *smpt, *tpt, *ppt, *deltapt, *gammapt, *vegapt, *thetapt, *rhopt,
          *crhopt, *vannapt, *charmpt, *speedpt, *colourpt, *zommapt, *vommapt;
  jboolean isCopy;

  smpt = (*env)->GetDoubleArrayElements(env, sm, &isCopy);
  tpt = (*env)->GetDoubleArrayElements(env, t, &isCopy);
  ppt = (*env)->GetDoubleArrayElements(env, p, &isCopy);
  deltapt = (*env)->GetDoubleArrayElements(env, delta, &isCopy);
  gammapt = (*env)->GetDoubleArrayElements(env, gamma, &isCopy);
  vegapt = (*env)->GetDoubleArrayElements(env, vega, &isCopy);
  thetapt = (*env)->GetDoubleArrayElements(env, theta, &isCopy);
  rhopt = (*env)->GetDoubleArrayElements(env, rho, &isCopy);
  crhopt = (*env)->GetDoubleArrayElements(env, crho, &isCopy);
  vannapt = (*env)->GetDoubleArrayElements(env, vanna, &isCopy);
  charmpt = (*env)->GetDoubleArrayElements(env, charm, &isCopy);
  speedpt = (*env)->GetDoubleArrayElements(env, speed, &isCopy);
  colourpt = (*env)->GetDoubleArrayElements(env, colour, &isCopy);
  zommapt = (*env)->GetDoubleArrayElements(env, zomma, &isCopy);
  vommapt = (*env)->GetDoubleArrayElements(env, vomma, &isCopy);

  /* Call S30BBF */
  ifail = -1;
#ifdef WINDOWS
  S30BBF(&calput, 1, 
#else
  s30bbf_(&calput,
#endif 
       &m, &n, smpt, &s, tpt, &sigma, &r, &q, ppt, &ldp, deltapt,  
       gammapt, vegapt, thetapt, rhopt, crhopt, vannapt, charmpt, speedpt,
       colourpt, zommapt, vommapt, &ifail);

  /* Release the array elements back to Java */
  (*env)->ReleaseDoubleArrayElements(env, sm, smpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, t, tpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, p, ppt, 0);
  (*env)->ReleaseDoubleArrayElements(env, delta, deltapt, 0);
  (*env)->ReleaseDoubleArrayElements(env, gamma, gammapt, 0);
  (*env)->ReleaseDoubleArrayElements(env, vega, vegapt, 0);
  (*env)->ReleaseDoubleArrayElements(env, theta, thetapt, 0);
  (*env)->ReleaseDoubleArrayElements(env, rho, rhopt, 0);
  (*env)->ReleaseDoubleArrayElements(env, crho, crhopt, 0);
  (*env)->ReleaseDoubleArrayElements(env, vanna, vannapt, 0);
  (*env)->ReleaseDoubleArrayElements(env, charm, charmpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, speed, speedpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, colour, colourpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, zomma, zommapt, 0);
  (*env)->ReleaseDoubleArrayElements(env, vomma, vommapt, 0);

  return ifail;
}
