public class FSLOptPrice
{

  // Declaration of the Native (C) function
  private native int s30baf(char calput, int m, int n, double[] sm, double s,
                            double[] t, double sigma, double r, double q, 
                            double[] p, int ldp);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double sm[], t[], p[];
      double s, sigma, r, q;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class FSLOptPrice
      FSLOptPrice price = new FSLOptPrice();

      calput = 'C';
      s = 120.0;
      sigma = 0.3;
      r = 0.1;
      q = 0.06;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n]; 
      sm = new double[m];
      t = new double[n];

      sm[0] = 100.0;
      t[0] = 0.5;

      System.out.println();
      System.out.println("Call of NAG Floating-strike lookback option pricing routine S30BAF");
      System.out.println();

      // Call method s30baf of object price
      retCode = price.s30baf(calput, m, n, sm, s, t, sigma, r, q, p, ldp);

      System.out.print("Return code from S30BAF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("European Call:");
          System.out.println("Spot " + s);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Dividend " + q);
          System.out.println();

          // Print the solution
          System.out.println(" Strike      Expiry   Option Price");
          for (i = 0; i < m; i++)
            for (j = 0; j < n; j++)
            {
              System.out.format("%8.4f   %8.4f   %8.4f%n",sm[i],t[j],p[j*m + i]);
            }
        }
      System.out.println();
    }
}
