#include <jni.h>      /* Java Native Interface headers */
#include "EuropeanOptPrice.h"   /* Auto-generated header created by javah -jni */

/* Our C definition of the function S30AAF declared in EuropeanOptPrice.java */
JNIEXPORT jint JNICALL Java_EuropeanOptPrice_s30aaf
  (JNIEnv *env, jobject obj, jchar calput, jint m, jint n, jdoubleArray x, 
   jdouble s, jdoubleArray t, jdouble sigma, jdouble r, jdouble q, 
   jdoubleArray p, jint ldp)
{
  /* Local variable ifail*/
  int ifail;

  /* First extract the arrays from Java */
  jdouble *xpt, *tpt, *ppt;
  jboolean isCopy;

  xpt = (*env)->GetDoubleArrayElements(env, x, &isCopy);
  tpt = (*env)->GetDoubleArrayElements(env, t, &isCopy);
  ppt = (*env)->GetDoubleArrayElements(env, p, &isCopy);

  /* Call S30AAF */
  ifail = -1;
#ifdef WINDOWS
  S30AAF(&calput, 1, 
#else
  s30aaf_(&calput,
#endif 
      &m, &n, xpt, &s, tpt, &sigma, &r, &q, ppt, &ldp, &ifail);

  /* Release the array elements back to Java */
  (*env)->ReleaseDoubleArrayElements(env, x, xpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, t, tpt, 0);
  (*env)->ReleaseDoubleArrayElements(env, p, ppt, 0);

  return ifail;
}
