public class BinaryOptPrice
{

  // Declaration of the Native (C) function
  private native int s30caf(char calput, int m, int n, double[] x, double s,
                            double k, double[] t, double sigma, double r, 
                            double q, double[] p, int ldp);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[];
      double s, k, sigma, r, q;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class BinaryOptPrice
      BinaryOptPrice price = new BinaryOptPrice();

      calput = 'P';
      s = 100.0;
      k = 10.0;
      sigma = 0.35;
      r = 0.06;
      q = 0.0;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n]; 
      x = new double[m];
      t = new double[n];

      x[0] = 80.0;
      t[0] = 0.75;

      System.out.println();
      System.out.println("Call of NAG Binary option: cash-or-nothing pricing routine S30CAF");
      System.out.println();

      // Call method s30caf of object price
      retCode = price.s30caf(calput, m, n, x, s, k, t, sigma, r, q, p, ldp);

      System.out.print("Return code from S30CAF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("European Put:");
          System.out.println("Spot " + s);
          System.out.println("Payout " + k);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Dividend " + q);
          System.out.println();

          // Print the solution
          System.out.println(" Strike      Expiry   Option Price");
          for (i = 0; i < m; i++)
            for (j = 0; j < n; j++)
            {
              System.out.format("%8.4f   %8.4f   %8.4f%n",x[i],t[j],p[j*m + i]);
            }
        }
      System.out.println();
    }
}
