public class AsianOptPriceGreeks
{

  // Declaration of the Native (C) function
  private native int s30sbf(char calput, int m, int n, double[] x, double s,
                            double[] t, double sigma, double r, double b, 
                            double[] p, int ldp, double[] delta,  
                            double[] gamma, double[] vega, double[] theta,
                            double[] rho, double[] crho, double[] vanna,
                            double[] charm, double[] speed,  double[] colour,
                            double[] zomma, double[] vomma);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[], delta[], gamma[], vega[], theta[], rho[], crho[],
             vanna[], charm[], speed[], colour[], zomma[], vomma[];
      double s, sigma, r, b;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class AsianOptPriceGreeks
      AsianOptPriceGreeks price = new AsianOptPriceGreeks();

      calput = 'C';
      s = 80.0;
      sigma = 0.2;
      r = 0.05;
      b = 0.08;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n];
      delta = new double[ldp*n];
      gamma = new double[ldp*n];
      vega = new double[ldp*n];
      theta = new double[ldp*n];
      rho = new double[ldp*n];
      crho = new double[ldp*n];
      vanna = new double[ldp*n];
      charm = new double[ldp*n];
      speed = new double[ldp*n];
      colour = new double[ldp*n];
      zomma = new double[ldp*n];
      vomma = new double[ldp*n];
      x = new double[m];
      t = new double[n];

      x[0] = 97.0;
      t[0] = 0.25;

      System.out.println();
      System.out.println("Call of NAG Asian geometric continuous average-rate option pricing with Greeks routine S30SBF");
      System.out.println();

      // Call method s30sbf of object price
      retCode = price.s30sbf(calput, m, n, x, s, t, sigma, r, b, p, ldp, delta,  
                             gamma, vega, theta, rho, crho, vanna, charm, speed,
                             colour, zomma, vomma);

      System.out.print("Return code from S30SBF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("Asian Call:");
          System.out.println("Spot " + s);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Cost of carry " + b);
          System.out.println();

          // Print the solution
          for (j = 0; j < n; j++)
            {
              System.out.println("Time to Expiry : " + t[j]);
              System.out.print(" Strike     Price     Delta     Gamma    ");
              System.out.println("Vega      Theta      Rho        CRho");
              for (i = 0; i < m; i++)
                {
                  System.out.format("%7.4f   %7.4f   %7.4f   ",x[i],p[j*m + i],delta[j*m + i]);
                  System.out.format("%7.4f   %7.4f",gamma[j*m + i],vega[j*m + i]);
                  System.out.format("   %7.4f   %7.4f   %7.4f",theta[j*m + i],rho[j*m + i],crho[j*m + i]);
                }
              System.out.println();
              System.out.print(" Strike     Price     Vanna    Charm     Speed");
              System.out.println("     Colour    Zomma      Vomma");
              for (i = 0; i < m; i++)
                {
                  System.out.format("%7.4f   %7.4f   %7.4f   ",x[i],p[j*m + i],vanna[j*m + i]);
                  System.out.format("%7.4f   %7.4f",charm[j*m + i],speed[j*m + i]);
                  System.out.format("   %7.4f   %7.4f   %7.4f",colour[j*m + i],zomma[j*m + i],vomma[j*m + i]);
                }
              System.out.println();
            }
        }
    }
}
