public class AsianOptPrice
{

  // Declaration of the Native (C) function
  private native int s30saf(char calput, int m, int n, double[] x, double s,
                            double[] t, double sigma, double r, double b, 
                            double[] p, int ldp);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[];
      double s, sigma, r, b;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class AsianOptPrice
      AsianOptPrice price = new AsianOptPrice();

      calput = 'P';
      s = 80.0;
      sigma = 0.2;
      r = 0.05;
      b = 0.08;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n];
      x = new double[m];
      t = new double[n];

      x[0] = 85.0;
      t[0] = 0.25;

      System.out.println();
      System.out.println("Call of NAG Asian geometric continuous average-rate option pricing routine S30SAF");
      System.out.println();

      // Call method s30saf of object price
      retCode = price.s30saf(calput, m, n, x, s, t, sigma, r, b, p, ldp);

      System.out.print("Return code from S30SAF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("Asian Put:");
          System.out.println("Spot " + s);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Cost of carry " + b);
          System.out.println();

          // Print the solution
          System.out.println(" Strike      Expiry     Option Price");
          for (i = 0; i < m; i++)
            {
              for (j = 0; j < n; j++)
                System.out.format("%8.4f   %8.4f   %8.4f%n",x[i],t[j],p[j*m + i]);
            }
          System.out.println();
        }
    }
}
