public class AmericanOptPrice
{

  // Declaration of the Native (C) function
  private native int s30qcf(char calput, int m, int n, double[] x, double s,
                            double[] t, double sigma, double r, double q, 
                            double[] p, int ldp);

  static
    {
      // The runtime system executes a class's static
      // initializer when it loads the class.
      System.loadLibrary("nagCJavaInterface");
    }

  // The main program
  public static void main(String[] args)
    {
      double x[], t[], p[];
      double s, sigma, r, q;
      int i, j, m, n, ldp, retCode;
      char calput;

      // Create an object of class AmericanOptPrice
      AmericanOptPrice price = new AmericanOptPrice();

      calput = 'C';
      s = 110.0;
      sigma = 0.2;
      r = 0.08;
      q = 0.12;
      m = 1;
      n = 1;
      ldp = m;

      p = new double[ldp*n];
      x = new double[m];
      t = new double[n];

      x[0] = 100.0;
      t[0] = 0.25;

      System.out.println();
      System.out.println("Call of NAG American option: Bjerksund and Stensland pricing routine S30QCF");
      System.out.println();

      // Call method s30qcf of object price
      retCode = price.s30qcf(calput, m, n, x, s, t, sigma, r, q, p, ldp);

      System.out.print("Return code from S30QCF = ");
      System.out.println(retCode);
      System.out.println();

      if (retCode == 0)
        {
          // Print the input values
          System.out.println("American Call:");
          System.out.println("Spot " + s);
          System.out.println("Volatility " + sigma);
          System.out.println("Rate " + r);
          System.out.println("Dividend " + q);
          System.out.println();

          // Print the solution
          System.out.println(" Strike      Expiry    Option Price");
          for (i = 0; i < m; i++)
            {
              for (j = 0; j < n; j++)
                System.out.format("%8.4f   %8.4f   %8.4f%n",x[i],t[j],p[j*m + i]);
            }
          System.out.println();
        }
    }
}
