import json
import sys

def write_setting(setting_name, new_value):
    try:
        with open('prjsettings.json', 'r') as file:
            settings = json.load(file)
    except FileNotFoundError:
        settings = {}

    settings[setting_name] = new_value

    with open('prjsettings.json', 'w') as file:
        json.dump(settings, file, indent=4)

if __name__ == "__main__":
    if len(sys.argv) != 3:
        print("Usage: python write_settings.py <setting_name> <new_value>")
        sys.exit(1)

    setting_name = sys.argv[1]
    new_value = sys.argv[2]
    write_setting(setting_name, new_value)
    print("'" + setting_name + "' updated to '" + new_value + "'.")
