import sys
import argparse

def transform_dependency_line(line, build_dir):
    if line.strip() and ':' in line:
        target, deps = line.split(':')
        target = target.strip()

        # modify path of .o and .mod of targets
        if target.endswith('.o') or target.endswith('.mod'):
            target = build_dir + '/' + target if not '/' in target else target

        deps = deps.strip().split()
        # modify path of .mod of dependents
        deps = [build_dir + '/' + dep if dep.endswith('.mod') else dep for dep in deps]
        deps = ' '.join(deps)
        return target + ': ' + deps + '\n'
    return line

def main():
    parser = argparse.ArgumentParser(description="Transform dependency file.")
    parser.add_argument("--build_dir", required=True, help="Build directory name")
    args = parser.parse_args()

    build_dir = args.build_dir

    for line in sys.stdin:
        transformed_line = transform_dependency_line(line, build_dir)
        sys.stdout.write(transformed_line)

if __name__ == "__main__":
    main()
