import json
import sys

def read_setting(setting_name, default_value=None):
    try:
        with open('prjsettings.json', 'r') as file:
            settings = json.load(file)
        return settings.get(setting_name, default_value)
    except FileNotFoundError:
        print("Error: 'prjsettings.json' not found.")
        return default_value

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python read_settings.py <setting_name> [default_value]")
        sys.exit(1)

    setting_name = sys.argv[1]
    default_value = sys.argv[2] if len(sys.argv) > 2 else None
    value = read_setting(setting_name, default_value)
    if value is not None:
        print(value)
    else:
        print("Setting '{}' not found.".format(setting_name))
