import numpy as np

def save_rand_matrix(N):
    fname = f"matrix_{N}x{N}_rand_uniform.bin"
    # [-0.5, 0.5] の一様分布
    A = np.random.rand(N, N).astype(np.float64) - 0.5
    A.tofile(fname)
    print(f"Saved {fname} ({A.nbytes/1e9:.2f} GB)")

if __name__ == "__main__":
    for N in (100, 200, 400, 800, 1600, 2400, 3200):
        save_rand_matrix(N)
