! dsvdc_wrapper.f90
module dsvdc_wrapper_mod
    use svd, only: dsvdc, dp
    use, intrinsic :: iso_c_binding, only: c_int, c_double
    implicit none
    private

    public :: dsvdc_c

contains

    ! This is the C-compatible wrapper function.
    function dsvdc_c(x, n, p, s, e, u, v, job) result(info) &
        bind(c, name='dsvdc_c')

        ! Argument description
        integer(c_int), value, intent(in) :: n, p, job
        real(c_double), intent(inout) :: x(n, p)
        real(c_double), intent(out) :: s(min(n+1,p)), e(p), u(n, n), v(p, p)
        integer(c_int) :: info

        ! Local variable to capture info from the Fortran subroutine
        integer :: info_fortran

        ! Call the original Fortran dsvdc subroutine
        call dsvdc(x, n, p, s, e, u, v, job, info_fortran)

        ! Assign the result to the function's return value
        info = info_fortran

    end function dsvdc_c

end module dsvdc_wrapper_mod