# t_svd.py
"""
A simple test of the SVD module - Direct port of t_svd.f90
The matrix:
 ( 1  2  3 )
 ( 4  5  6 )
 ( 7  8  9 )
 (10 11 12 )
has singular values: 25.4624, 1.2907 and zero.
"""

import numpy as np
from python_src.dsvdc import dsvdc

def main():
    # Create the test matrix (4x3)
    # Note: Fortran is column-major, Python/NumPy is row-major by default
    x = np.zeros((4, 3), dtype=float, order='F')  # Use Fortran order
    value = 1.0
    for row in range(4):
        for col in range(3):
            x[row, col] = value
            value += 1.0
    
    # Prepare arrays for SVD
    s = np.zeros(4, dtype=float)
    e = np.zeros(3, dtype=float)
    u = np.zeros((4, 4), dtype=float, order='F')
    v = np.zeros((3, 3), dtype=float, order='F')
    
    # Call dsvdc with job=11 (compute both U and V)
    info = dsvdc(x, 4, 3, s, e, u, v, 11)
    
    # Output the singular values
    print(f" The calculated singular values = {s[0]:10.4f}{s[1]:10.4f}{s[2]:10.4f}{s[3]:10.4f}")
    print()
    
    # Output the U matrix
    print("      The U-matrix")
    for row in range(4):
        print(f"{u[row,0]:10.4f}{u[row,1]:10.4f}{u[row,2]:10.4f}{u[row,3]:10.4f}")
    
    # Empty line before V matrix
    print()
    
    # Now the right-hand or V-matrix
    print("      The V-matrix")
    for row in range(3):
        print(f"{v[row,0]:10.4f}{v[row,1]:10.4f}{v[row,2]:10.4f}")

if __name__ == "__main__":
    main()