PROGRAM Test_DSVDC_Advanced
  USE SVD  ! dsvdc, drotg, dswap1, drot1, dp ܂܂郂W[
  IMPLICIT NONE

  !---------------------------------------------------------------------
  !  錾ZNV START 
  !---------------------------------------------------------------------
  ! eXgpz̍ő原 (KvɉĒĂ)
  INTEGER, PARAMETER :: N_max = 10
  INTEGER, PARAMETER :: P_max = 10

  REAL (dp) :: x(0:N_max-1, 0:P_max-1)
  REAL (dp) :: s(0:MAX(N_max, P_max)-1)     ! dsvdc ̏oS
  REAL (dp) :: e(0:P_max-1)
  REAL (dp) :: u(0:N_max-1, 0:N_max-1) ! U͍ő N x N
  REAL (dp) :: v(0:P_max-1, 0:P_max-1) ! V͍ő P x P
  INTEGER   :: n, p, job, info
  INTEGER   :: i, j
  REAL (dp) :: value
  INTEGER   :: row, col

  ! eXgP[XJE^[
  INTEGER :: test_count = 0

  ! JOBl̃oG[VeXgpϐ
  INTEGER, DIMENSION(4) :: job_values = [00, 01, 10, 21] 
  CHARACTER(LEN=50) :: job_desc
  INTEGER :: jv_idx 
  !---------------------------------------------------------------------
  !  錾ZNV END 
  !---------------------------------------------------------------------

  !---------------------------------------------------------------------
  !  sZNV START 
  !---------------------------------------------------------------------
  WRITE(*,*) '=============================================================='
  WRITE(*,*) 'DSVDC Advanced Test Program START for Refactored Fortran'
  WRITE(*,*) '=============================================================='
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Original Example (N=4, P=3, JOB=11) ---'
  n = 4
  p = 3
  job = 11 ! U (NxN), V (PxP) vZ

  ! vvgTest_SVD̏ɍ킹
  value = 1.0_dp
  DO row = 0, n-1
    DO col = 0, p-1
      x(row,col) = value
      value = value + 1.0_dp
    END DO
  END DO

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Square Well-Conditioned (N=3, P=3, JOB=11) ---'
  n = 3
  p = 3
  job = 11

  x = 0.0_dp
  x(0,0) = 4.0_dp; x(0,1) = 1.0_dp; x(0,2) = -1.0_dp
  x(1,0) = 1.0_dp; x(1,1) = 2.0_dp; x(1,2) =  1.0_dp
  x(2,0) =-1.0_dp; x(2,1) = 1.0_dp; x(2,2) =  3.0_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Tall Matrix (N=5, P=2, JOB=11) ---'
  n = 5
  p = 2
  job = 11

  x = 0.0_dp
  DO j = 0, p-1 
    DO i = 0, n-1 
      x(i,j) = REAL((i+1) + j*n, dp)
    END DO
  END DO

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Wide Matrix (N=2, P=5, JOB=11) ---'
  n = 2
  p = 5
  job = 11

  x = 0.0_dp
  DO j = 0, p-1 
    DO i = 0, n-1 
      x(i,j) = REAL((j+1) + i*p, dp)
    END DO
  END DO

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Rank Deficient (N=3, P=3, Col3=Col1+Col2, JOB=11) ---'
  n = 3
  p = 3
  job = 11

  x = 0.0_dp
  x(0,0) = 1.0_dp; x(1,0) = 2.0_dp; x(2,0) = 3.0_dp
  x(0,1) = 4.0_dp; x(1,1) = 5.0_dp; x(2,1) = 6.0_dp
  x(0,2) = x(0,0) + x(0,1)
  x(1,2) = x(1,0) + x(1,1)
  x(2,2) = x(2,0) + x(2,1)

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: One singular value should be close to zero.'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Zero Matrix (N=3, P=2, JOB=11) ---'
  n = 3
  p = 2
  job = 11
  x = 0.0_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: All singular values should be close to zero.'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Diagonal Matrix (N=3, P=3, JOB=11) ---'
  n = 3
  p = 3
  job = 11
  x = 0.0_dp
  x(0,0) = 5.0_dp
  x(1,1) = -2.0_dp
  x(2,2) = 1.0_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: Singular values should be ABS of diagonal entries (5, 2, 1), possibly reordered.'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)
  
  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Diagonal Matrix with repeated SVs (N=3, P=3, JOB=11) ---'
  n = 3
  p = 3
  job = 11
  x = 0.0_dp
  x(0,0) = 2.0_dp
  x(1,1) = -2.0_dp
  x(2,2) = 1.0_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: Singular values should be (2, 2, 1), possibly reordered.'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': 1x1 Matrix (N=1, P=1, JOB=11) ---'
  n = 1
  p = 1
  job = 11
  x = 0.0_dp 
  x(0,0) = -7.0_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: Singular value should be 7.'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': 2x1 Matrix (N=2, P=1, JOB=11) ---'
  n = 2
  p = 1
  job = 11
  x = 0.0_dp 
  x(0,0) = 3.0_dp
  x(1,0) = 4.0_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: Singular value should be 5.'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': 1x2 Matrix (N=1, P=2, JOB=11) ---'
  n = 1
  p = 2
  job = 11
  x = 0.0_dp 
  x(0,0) = 3.0_dp
  x(0,1) = 4.0_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: Singular value should be 5.'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)
  
  !---------------------------------------------------------------------
  test_count = test_count + 1
  WRITE(*,'(A,I2,A)') '--- Test Case ', test_count, ': Ill-conditioned like (Diagonal N=2, P=2, JOB=11) ---'
  n = 2
  p = 2
  job = 11
  x = 0.0_dp
  x(0,0) = 1.0E8_dp
  x(1,1) = 1.0E-8_dp

  CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
  CALL dsvdc(x, n, p, s, e, u, v, job, info)
  CALL print_svd_results(s, e, u, v, n, p, job, info)
  WRITE(*,*) 'Expected: Singular values 1E8 and 1E-8. Check convergence (info=0).'
  WRITE(*,*) '--------------------------------------------------------------'
  WRITE(*,*)

  !---------------------------------------------------------------------
  WRITE(*,*) '--- Testing different JOB values with N=4, P=3 matrix ---'
  n = 4 ! sȂ̂Ő錾ZNV̌łKv (ɂȂĂ܂)
  p = 3 ! sȂ̂Ő錾ZNV̌łKv (ɂȂĂ܂)

  DO jv_idx = 1, SIZE(job_values) 
    job = job_values(jv_idx)
    test_count = test_count + 1
    
    SELECT CASE (job)
    CASE (00)
      job_desc = 'JOB=00 (S only)'
    CASE (01)
      job_desc = 'JOB=01 (S, V)'
    CASE (10)
      job_desc = 'JOB=10 (S, U full)'
    CASE (21)
      job_desc = 'JOB=21 (S, U thin, V)'
    CASE DEFAULT
      job_desc = 'Unknown JOB value'
    END SELECT

    WRITE(*,'(A,I2,A,A)') '--- Test Case ', test_count, ': ', TRIM(job_desc), ' ---'
    
    value = 1.0_dp
    DO row = 0, n-1
      DO col = 0, p-1
        x(row,col) = value
        value = value + 1.0_dp
      END DO
    END DO

    CALL print_matrix_info(x(0:n-1,0:p-1), n, p, job, 'Input Matrix X:')
    CALL dsvdc(x, n, p, s, e, u, v, job, info)
    CALL print_svd_results(s, e, u, v, n, p, job, info)
    WRITE(*,*) '--------------------------------------------------------------'
    WRITE(*,*)
  END DO

  !---------------------------------------------------------------------
  !  sZNV END 
  !---------------------------------------------------------------------

  WRITE(*,*) '=============================================================='
  WRITE(*,*) 'DSVDC Advanced Test Program END'
  WRITE(*,*) '=============================================================='

CONTAINS

  SUBROUTINE print_matrix_info(mat, num_rows, num_cols, current_job, title)
    !  錾ZNV (Tu[`) START 
    REAL (dp), INTENT(IN) :: mat(0:,0:) 
    INTEGER, INTENT(IN)   :: num_rows, num_cols, current_job
    CHARACTER(LEN=*), INTENT(IN) :: title
    INTEGER :: r_print, c_print 
    !  錾ZNV (Tu[`) END 

    !  sZNV (Tu[`) START 
    WRITE(*,*) TRIM(title)
    WRITE(*,'(A,I0,A,I0,A,I0)') "N=", num_rows, ", P=", num_cols, ", JOB=", current_job
    IF (num_rows <= 0 .OR. num_cols <= 0) THEN
        WRITE(*,*) "Matrix is empty or has invalid dimensions."
        RETURN
    ENDIF
    IF (SIZE(mat,1) < num_rows .OR. SIZE(mat,2) < num_cols) THEN
        WRITE(*,*) "Warning in print_matrix_info: num_rows/num_cols might exceed dimensions of passed matrix."
        WRITE(*,*) "SIZE(mat,1)=", SIZE(mat,1), " (expected >=", num_rows, ")"
        WRITE(*,*) "SIZE(mat,2)=", SIZE(mat,2), " (expected >=", num_cols, ")"
    ENDIF

    WRITE(*,*) "Matrix elements (first few rows/cols if large):"
    DO r_print = 0, MIN(num_rows-1, 4, SIZE(mat,1)-1) 
      WRITE(*,'(100(ES12.4,1X))') (mat(r_print,c_print), c_print=0,MIN(num_cols-1,4,SIZE(mat,2)-1)) 
    END DO
    IF (num_rows > MIN(5,SIZE(mat,1)) .OR. num_cols > MIN(5,SIZE(mat,2))) THEN 
        WRITE(*,*) "..."
    ENDIF
    WRITE(*,*)
    !  sZNV (Tu[`) END 
  END SUBROUTINE print_matrix_info

  SUBROUTINE print_svd_results(s_vec, e_vec, u_mat, v_mat, num_rows, num_cols, current_job, ret_info)
    !  錾ZNV (Tu[`) START 
    REAL (dp), INTENT(IN) :: s_vec(0:) 
    REAL (dp), INTENT(IN) :: e_vec(0:) 
    REAL (dp), INTENT(IN) :: u_mat(0:,0:)
    REAL (dp), INTENT(IN) :: v_mat(0:,0:)
    INTEGER, INTENT(IN)   :: num_rows, num_cols, current_job, ret_info
    INTEGER :: r_print, c_print, num_sv_to_print, ncu_actual 
    INTEGER :: jobu, jobv 
    INTEGER :: i     

    !  sZNV (Tu[`) START 
    WRITE(*,*) "SVD Results:"
    WRITE(*,'(A,I0)') "INFO = ", ret_info
    IF (ret_info /= 0) THEN
      WRITE(*,*) "*** WARNING: DSVDC did not converge completely. INFO = ", ret_info
    END IF

    num_sv_to_print = MIN(num_rows, num_cols)
    IF (num_sv_to_print > 0 .AND. num_sv_to_print <= SIZE(s_vec)) THEN 
        WRITE(*,'(A,100(ES12.4,1X))') "Singular values S = ", (s_vec(i), i=0,num_sv_to_print-1)
    ELSE IF (num_sv_to_print > 0) THEN
        WRITE(*,*) "Warning: Not enough elements in s_vec to print ", num_sv_to_print, " singular values. SIZE(s_vec)=", SIZE(s_vec)
    ELSE
        WRITE(*,*) "No singular values to print."
    END IF

    IF (num_cols > 0 .AND. num_cols <= SIZE(e_vec)) THEN
        WRITE(*,'(A,100(ES12.4,1X))') "Superdiagonal E (full) = ", (e_vec(i), i=0,num_cols-1) 
    ELSE IF (num_cols > 0) THEN
        WRITE(*,*) "Warning: Not enough elements in e_vec to print. SIZE(e_vec)=", SIZE(e_vec)
    END IF
    WRITE(*,*)

    jobu = current_job / 10
    jobv = MOD(current_job, 10)

    IF (jobu /= 0) THEN
      WRITE(*,*) "Matrix U (first few rows/cols if large):"
      IF (jobu == 1) THEN
        ncu_actual = num_rows 
        WRITE(*,*) "(Computed as N x N)"
      ELSE 
        ncu_actual = MIN(num_rows, num_cols) 
        WRITE(*,*) "(Computed as N x min(N,P))"
      END IF
      IF (num_rows <= SIZE(u_mat,1) .AND. ncu_actual <= SIZE(u_mat,2)) THEN
          DO r_print = 0, MIN(num_rows-1, 4)
            WRITE(*,'(100(F8.3,1X))') (u_mat(r_print,c_print), c_print=0,MIN(ncu_actual-1,4))
          END DO
          IF (num_rows > 5 .OR. ncu_actual > 5) THEN
            WRITE(*,*) "..."
          ENDIF
      ELSE
          WRITE(*,*) "Warning: Dimensions for U printing exceed u_mat bounds."
          WRITE(*,*) "SIZE(u_mat)=", SIZE(u_mat,1), ",", SIZE(u_mat,2), " vs N,NCU=", num_rows, ",", ncu_actual
      ENDIF
      WRITE(*,*)
    ELSE
      WRITE(*,*) "Matrix U was not computed (JOB)."
      WRITE(*,*)
    END IF

    IF (jobv /= 0) THEN
      WRITE(*,*) "Matrix V (first few rows/cols if large):"
      WRITE(*,*) "(Computed as P x P)"
      IF (num_cols <= SIZE(v_mat,1) .AND. num_cols <= SIZE(v_mat,2)) THEN 
          DO r_print = 0, MIN(num_cols-1, 4) 
            WRITE(*,'(100(F8.3,1X))') (v_mat(r_print,c_print), c_print=0,MIN(num_cols-1,4))
          END DO
          IF (num_cols > 5) THEN 
            WRITE(*,*) "..."
          ENDIF
      ELSE
          WRITE(*,*) "Warning: Dimensions for V printing exceed v_mat bounds."
          WRITE(*,*) "SIZE(v_mat)=", SIZE(v_mat,1), ",", SIZE(v_mat,2), " vs P,P=", num_cols, ",", num_cols
      ENDIF
      WRITE(*,*)
    ELSE
      WRITE(*,*) "Matrix V was not computed (JOB)."
      WRITE(*,*)
    END IF
    !  sZNV (Tu[`) END 
  END SUBROUTINE print_svd_results

END PROGRAM Test_DSVDC_Advanced