Program book_recommendation_system
    Use :: data_load_module
    Use :: perform_svd_module
    Use :: recommendation_module
    Use, Intrinsic :: iso_fortran_env, Only: int64, real64
    Implicit None

    ! Ԍvpϐ
    Integer :: t1, t2, t_rate, t_max, diff

    ! 萔
    Integer, Parameter :: max_recommendations = 10
    Character (Len=*), Parameter :: books_file = 'books.tsv'
    Character (Len=*), Parameter :: reviews_file = 'reviews.tsv'

    ! Eʊi[p
    Type (recommendation_result), Allocatable :: recommended_books(:)
    Character (Len=100) :: target_book_title
    ! [U[͗pϐ
    Integer (int64) :: target_book_id
    Integer :: read_status, i
    Character (Len=10) :: user_input

    ! ϐ
    Integer :: num_users, num_books, k, nnz
    Real (real64), Allocatable :: u(:, :), sigma(:), vt(:, :)
    Integer (int64), Allocatable :: user_id_map(:), book_id_map(:)
    Character (Len=100), Allocatable :: book_titles(:)
    Integer, Allocatable :: ratings_row(:), ratings_col(:)
    Real (real64), Allocatable :: ratings_val(:)

    ! Rf[Vpϐ

    ! f[^ǂݍ
    Call load_data(books_file, reviews_file, num_books, num_users, book_id_map, user_id_map, book_titles, ratings_row, ratings_col, &
        ratings_val, nnz)

    ! fobO̕\
    Print *, 'Loaded data:'
    Print *, 'Number of books:', num_books
    Print *, 'Number of users:', num_users
    Print *, 'Number of ratings:', nnz

    ! SVD̎sƎԌv
    Call system_clock(t1)
    k = 300                        ! ْl̐
    Call perform_svd(num_users, num_books, k, ratings_row, ratings_col, ratings_val, nnz, u, sigma, vt)
    Call system_clock(t2, t_rate, t_max)

    ! oߎԂ̌vZƕ\
    If (t2<t1) Then
        diff = (t_max-t1) + t2 + 1
    Else
        diff = t2 - t1
    End If
    Print '(A, F10.3)', 'SVD computation time (seconds):', diff/real(t_rate, real64)

    ! SVDʂ̏\
    Print *, 'SVD completed:'
    Print *, 'Number of singular values computed:', size(sigma)
    Print *, 'First few singular values:'
    Print *, sigma(1:min(5,size(sigma)))


    Write (*, '(A)') '{BookID͂Ăi0ŏIj: '
    Do
        Read (*, '(A)', Iostat=read_status) user_input
        If (read_status/=0) Then
            Write (*, '(A)') '̓G[łBēx͂ĂB'
            Cycle
        End If
        Read (user_input, *, Iostat=read_status) target_book_id
        If (read_status/=0) Then
            Write (*, '(A)') 'lȊO͂܂Bēx͂ĂB'
            Cycle
        End If
        If (target_book_id==0) Exit

        Call recommend_from_book_id(target_book_id, u, sigma, vt, books_file, book_id_map, max_recommendations, target_book_title, &
            recommended_books)

        If (allocated(recommended_books)) Then
            Write (*, '(A,A)') '͂ꂽ{̃^Cg: ', trim(target_book_title)
            Write (*, '(A,A)') trim(target_book_title), 'ɊÂĂ߂̖{F'
            Do i = 1, size(recommended_books)
                Write (*, '(I0,A,A,A,F8.3)') recommended_books(i)%book_id, ',', trim(recommended_books(i)%title), ',', &
                    recommended_books(i)%predicted_rating
            End Do
            Deallocate (recommended_books)
        End If

        Write (*, '(A)') '{BookID͂Ăi0ŏIj: '
    End Do

    ! ̉
    Deallocate (book_id_map, user_id_map, book_titles)
    Deallocate (ratings_row, ratings_col, ratings_val)
    Deallocate (u, sigma, vt)

    Print *, 'Program completed successfully.'

End Program book_recommendation_system
