Module perform_svd_module
    Use :: nag_library, Only: f02wgf, nag_wp
    Implicit None
    Private
    Public :: perform_svd

Contains

    Subroutine perform_svd(m, n, k, ratings_row, ratings_col, ratings_val, nnz, u, sigma, vt)
        Integer, Intent (In) :: m, n, k, nnz
        Integer, Intent (In) :: ratings_row(:), ratings_col(:)
        Real (Kind=nag_wp), Intent (In) :: ratings_val(:)
        Real (Kind=nag_wp), Allocatable, Intent (Out) :: u(:, :), sigma(:), vt(:, :)

        Integer :: ncv, nconv, ifail, ldu, ldv, i, j
        Real (Kind=nag_wp), Allocatable :: resid(:)
        Integer, Allocatable, Target :: iuser(:)
        Real (Kind=nag_wp), Allocatable, Target :: ruser(:)
        Real (Kind=nag_wp), Allocatable :: temp_vt(:, :)

        External :: av

        ! Set up parameters for f02wgf
        ncv = min(n, max(2*k+1,20))
        ldu = m
        ldv = n

        ! Allocate arrays
        Allocate (u(ldu,ncv), vt(ldv,ncv), sigma(ncv), resid(ncv))
        Allocate (iuser(3+2*nnz), ruser(nnz))

        ! Set up iuser and ruser for av routine
        iuser(1) = m
        iuser(2) = n
        iuser(3) = nnz
        iuser(4:3+nnz) = ratings_row
        iuser(4+nnz:3+2*nnz) = ratings_col
        ruser(1:nnz) = ratings_val

        ! Call f02wgf
        ifail = 0
        Call f02wgf(m, n, k, ncv, av, nconv, sigma, u, ldu, vt, ldv, resid, iuser, ruser, ifail)

        If (ifail/=0) Then
            Print *, 'Error in f02wgf: ifail =', ifail
            Stop
        End If

        ! Resize U, sigma, and Vt to only include converged singular values/vectors
        u = u(:, 1:nconv)
        sigma = sigma(1:nconv)

        ! Vt̓]u
        Allocate (temp_vt(nconv,ldv))
        Do i = 1, ldv
            Do j = 1, nconv
                temp_vt(j, i) = vt(i, j)
            End Do
        End Do
        Deallocate (vt)
        Allocate (vt(nconv,ldv))
        vt = temp_vt
        Deallocate (temp_vt)
        Deallocate (resid, iuser, ruser)
    End Subroutine perform_svd

End Module perform_svd_module

Subroutine av(iflag, m, n, x, y, iuser, ruser)
    Use :: nag_library, Only: nag_wp
    Implicit None
    Integer, Intent (Inout) :: iflag
    Integer, Intent (In) :: m, n
    Real (Kind=nag_wp), Intent (In) :: x(*)
    Real (Kind=nag_wp), Intent (Out) :: y(*)
    Integer, Intent (In), Target :: iuser(*)
    Real (Kind=nag_wp), Intent (In), Target :: ruser(*)

    Integer :: i, nnz
    Integer, Pointer :: rows(:), cols(:)
    Real (Kind=nag_wp), Pointer :: vals(:)

    nnz = iuser(3)
    rows => iuser(4:3+nnz)
    cols => iuser(4+nnz:3+2*nnz)
    vals => ruser(1:nnz)

    If (iflag==1) Then
        ! Compute A * x
        y(1:m) = 0.0_nag_wp
        Do i = 1, nnz
            y(rows(i)) = y(rows(i)) + vals(i)*x(cols(i))
        End Do
    Else If (iflag==2) Then
        ! Compute A^T * x
        y(1:n) = 0.0_nag_wp
        Do i = 1, nnz
            y(cols(i)) = y(cols(i)) + vals(i)*x(rows(i))
        End Do
    Else
        iflag = -1                 ! Signal an error
    End If
End Subroutine av
