Module data_load_module
    Use, Intrinsic :: iso_fortran_env, Only: int64, real64
    Implicit None
    Private
    Public :: load_data, get_book_index

Contains

    Subroutine load_data(books_file, reviews_file, num_books, num_users, book_id_list, user_id_map, book_titles, ratings_row, &
        ratings_col, ratings_val, nnz)
        Character (Len=*), Intent (In) :: books_file, reviews_file
        Integer, Intent (Out) :: num_books, num_users, nnz
        Integer (int64), Allocatable, Intent (Out) :: book_id_list(:), user_id_map(:)
        Character (Len=100), Allocatable, Intent (Out) :: book_titles(:)
        Integer, Allocatable, Intent (Out) :: ratings_row(:), ratings_col(:)
        Real (real64), Allocatable, Intent (Out) :: ratings_val(:)

        Integer :: i, ios
        Integer (int64) :: book_id, user_id, min_user_id, max_user_id
        Real (real64) :: rating
        Logical, Allocatable :: user_exists(:)
        Character (Len=1000) :: line

        ! r[f[^ӂȖ{ID̃Xg쐬
        Call create_unique_book_list(reviews_file, book_id_list, num_books)

        ! {̃^Cgǂݍ
        Call load_book_titles(books_file, book_id_list, book_titles, num_books)

        ! r[̐ƃ[U[ID͈̔͂擾
        Call count_reviews_and_user_id_range(reviews_file, nnz, min_user_id, max_user_id)

        ! z̊m
        Allocate (user_exists(min_user_id:max_user_id))
        user_exists = .False.
        Allocate (ratings_row(nnz), ratings_col(nnz), ratings_val(nnz))

        ! r[̃f[^ǂݍ
        Open (Unit=11, File=reviews_file, Status='old', Action='read')
        Read (11, '(A)') line      ! wb_[XLbv
        num_users = 0
        Do i = 1, nnz
            Call read_review_line(11, user_id, book_id, rating, ios)
            If (ios/=0) Exit
            If (.Not. user_exists(user_id)) Then
                user_exists(user_id) = .True.
                num_users = num_users + 1
            End If
            ratings_row(i) = user_id
            ratings_col(i) = get_book_index(book_id, book_id_list, num_books)
            If (ratings_col(i)==-1) Then
                Print *, 'Error: book_id ', book_id, ' not found in book_id_list.'
                Stop
            End If
            ratings_val(i) = rating
        End Do
        Close (11)

        ! [U[ID̃}bsO쐬
        Allocate (user_id_map(min_user_id:max_user_id))
        user_id_map = 0
        i = 1
        Do user_id = min_user_id, max_user_id
            If (user_exists(user_id)) Then
                user_id_map(user_id) = i
                i = i + 1
            End If
        End Do

        ! ratings_row̃[U[IDCfbNXɕϊ
        Do i = 1, nnz
            ratings_row(i) = user_id_map(ratings_row(i))
        End Do

        Deallocate (user_exists)
    End Subroutine load_data

    Subroutine create_unique_book_list(reviews_file, book_id_list, num_books)
        Character (Len=*), Intent (In) :: reviews_file
        Integer (int64), Allocatable, Intent (Out) :: book_id_list(:)
        Integer, Intent (Out) :: num_books

        Integer :: j, ios, list_size, unique_count
        Integer (int64) :: user_id, book_id
        Real (real64) :: rating
        Integer (int64), Allocatable :: temp_list(:)
        Logical :: is_duplicate
        Character (Len=1000) :: line

        ! ꎞIȃXg̃TCYς
        list_size = 10000          ! KȏTCY
        Allocate (temp_list(list_size))
        unique_count = 0

        ! r[t@C{IDǂݍ
        Open (Unit=11, File=reviews_file, Status='old', Action='read')
        Read (11, '(A)') line      ! wb_[XLbv

        Do
            Call read_review_line(11, user_id, book_id, rating, ios)
            If (ios/=0) Exit

            ! d`FbN
            is_duplicate = .False.
            Do j = 1, unique_count
                If (temp_list(j)==book_id) Then
                    is_duplicate = .True.
                    Exit
                End If
            End Do

            If (.Not. is_duplicate) Then
                unique_count = unique_count + 1
                If (unique_count>list_size) Then
                    ! XgȂꍇ͊g
                    Call extend_list(temp_list, list_size)
                    list_size = list_size*2
                End If
                temp_list(unique_count) = book_id
            End If
        End Do
        Close (11)

        ! ŏIIȃXg쐬
        num_books = unique_count
        Allocate (book_id_list(num_books))
        book_id_list(1:num_books) = temp_list(1:num_books)

        Deallocate (temp_list)
    End Subroutine create_unique_book_list

    Subroutine extend_list(list, current_size)
        Integer (int64), Allocatable, Intent (Inout) :: list(:)
        Integer, Intent (In) :: current_size

        Integer (int64), Allocatable :: temp(:)
        Integer :: new_size

        new_size = current_size*2
        Allocate (temp(new_size))
        temp(1:current_size) = list
        Call move_alloc(temp, list)
    End Subroutine extend_list

    Subroutine load_book_titles(books_file, book_id_list, book_titles, num_books)
        Character (Len=*), Intent (In) :: books_file
        Integer (int64), Intent (In) :: book_id_list(:)
        Character (Len=100), Allocatable, Intent (Out) :: book_titles(:)
        Integer, Intent (In) :: num_books

        Integer :: i, ios, tab_pos, found_count
        Integer (int64) :: book_id
        Character (Len=1000) :: line
        Character (Len=100) :: title

        Allocate (book_titles(num_books))
        book_titles = 'Unknown Title' ! ftHgl

        Open (Unit=10, File=books_file, Status='old', Action='read')
        Read (10, '(A)') line      ! wb_[XLbv
        found_count = 0

        Do
            Read (10, '(A)', Iostat=ios) line
            If (ios/=0) Exit

            tab_pos = index(line, char(9))
            If (tab_pos>0) Then
                Read (line(1:tab_pos-1), *) book_id
                title = adjustl(line(tab_pos+1:))

                ! book_id_list̒Y{T
                Do i = 1, num_books
                    If (book_id_list(i)==book_id) Then
                        book_titles(i) = trim(title)
                        found_count = found_count + 1
                        Exit
                    End If
                End Do
            End If
        End Do
        Close (10)
    End Subroutine load_book_titles

    Subroutine count_reviews_and_user_id_range(reviews_file, nnz, min_user_id, max_user_id)
        Character (Len=*), Intent (In) :: reviews_file
        Integer, Intent (Out) :: nnz
        Integer (int64), Intent (Out) :: min_user_id, max_user_id

        Integer :: ios
        Integer (int64) :: user_id, book_id
        Real (real64) :: rating
        Character (Len=1000) :: line

        Open (Unit=11, File=reviews_file, Status='old', Action='read')
        Read (11, '(A)') line      ! wb_[XLbv
        nnz = 0
        min_user_id = huge(min_user_id)
        max_user_id = -huge(max_user_id)
        Do
            Call read_review_line(11, user_id, book_id, rating, ios)
            If (ios/=0) Exit
            nnz = nnz + 1
            min_user_id = min(min_user_id, user_id)
            max_user_id = max(max_user_id, user_id)
        End Do
        Close (11)
    End Subroutine count_reviews_and_user_id_range

    Subroutine read_review_line(unit, user_id, book_id, rating, ios)
        Integer, Intent (In) :: unit
        Integer (int64), Intent (Out) :: user_id, book_id
        Real (real64), Intent (Out) :: rating
        Integer, Intent (Out) :: ios

        Character (Len=1000) :: line
        Integer :: tab_pos1, tab_pos2

        Read (unit, '(A)', Iostat=ios) line
        If (ios/=0) Return

        tab_pos1 = index(line, char(9))
        If (tab_pos1>0) Then
            Read (line(1:tab_pos1-1), *) user_id
            tab_pos2 = index(line(tab_pos1+1:), char(9)) + tab_pos1
            If (tab_pos2>tab_pos1) Then
                Read (line(tab_pos1+1:tab_pos2-1), *) book_id
                Read (line(tab_pos2+1:), *) rating
            Else
                ios = -1           ! Error: not enough fields
            End If
        Else
            ios = -1               ! Error: no tab found
        End If
    End Subroutine read_review_line

    Integer Function get_book_index(book_id, book_id_list, num_books)
        Integer (int64), Intent (In) :: book_id
        Integer (int64), Intent (In) :: book_id_list(:)
        Integer, Intent (In) :: num_books
        Integer :: i

        Do i = 1, num_books
            If (book_id_list(i)==book_id) Then
                get_book_index = i
                Return
            End If
        End Do
        get_book_index = -1        ! Ȃꍇ
    End Function get_book_index

End Module data_load_module
