program mean_variance_portfolio_optimisation
  use nag_library, only: e04nff, e04nfu
  implicit none
  double precision obj, val
  integer :: i, ifail, iter, lda, liwork, lwork, n, nclin, sda, ir, ic
  double precision, allocatable :: a(:, :), ax(:), bl(:), bu(:), &
    mean_return(:), sd_return(:), clamda(:), cvec(:), covar(:, :), &
    corr(:, :), work(:), x(:)
  integer, allocatable :: istate(:), iwork(:)
  
  ! f[^t@C
  character(len = *), parameter :: data_file = 'port5.txt' 

  ! Ƃ̗vҎv
  double precision, parameter :: target_return = 0.0025d0

  ! f[^t@CJ
  open (10, file = data_file, status = 'old')

  ! Yǂݍ
  read (10, *) n

  ! 񎮂̌ݒ肷
  ! (a) |[gtHI̊Ҏv >= Ƃ̗vҎv
  ! (b) 䗦̍v = 1
  nclin = 2

  ! z蓖Ă
  liwork = 2 * n + 3
  lda = max(1, nclin)
  if (nclin > 0) then
    sda = n
  else
    sda = 1
  end if
  if (nclin > 0) then
    lwork = 2 * n ** 2 + 8 * n + 5 * nclin
  else
    lwork = n ** 2 + 8 * n
  end if
  allocate (istate(n + nclin), ax(max(1, nclin)), iwork(liwork), & 
    covar(n, n), corr(n, n), mean_return(n), sd_return(n), bl(n + nclin), &
    bu(n + nclin), cvec(1), x(n), a(lda, sda), clamda(n + nclin), work(lwork))

  ! eY̎v̕ρiҎvjƕW΍ǂݍ
  do i = 1, n
    read (10, *) mean_return(i), sd_return(i)
  end do

  ! YԂ̎v̑֌Wǂݍ
  corr = 0d0
  do i = 1, (n + 1) * n / 2
    read (10, *) ir, ic, val
    corr(ir, ic) = val
    corr(ic, ir) = val
  end do
  
  ! f[^t@C
  close (10)

  ! YԂ̎v̋UvZ
  covar = corr * &
    matmul(reshape(sd_return, (/n, 1/)), reshape(sd_return, (/1, n/)))

  ! 񎮂̍spӂ
  do i = 1, n
    a(1, i) = mean_return(i)
    a(2, i) = 1d0
  end do

  ! ϐi䗦jɉƏݒ肷
  do i = 1, n
    bl(i) = 0d0
    bu(i) = 1d0
  end do

  ! 񎮂ɉƏݒ肷
  bl(n + 1) = target_return
  bu(n + 1) = 1.0d+25 ! Ȃ
  bl(n + 2) = 1d0
  bu(n + 2) = 1d0

  ! ϐɏlݒ肷
  x = 1d0 / dble(n)

  ! Cʂo͂
  call e04nhf('Problem Type = QP1')
  ifail = 0
  call e04nff(n, nclin, a, lda, bl, bu, cvec, covar, n, e04nfu, istate, x, &
    iter, obj, ax, clamda, iwork, liwork, work, lwork, ifail)
end program
